SET statement_timeout = 0;
SET lock_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- Name: IX_HET_DIGITAL_FILE_EQUIPMENT_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_DIGITAL_FILE_EQUIPMENT_ID" ON public."HET_DIGITAL_FILE" USING btree ("EQUIPMENT_ID");


--
-- Name: IX_HET_DIGITAL_FILE_OWNER_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_DIGITAL_FILE_OWNER_ID" ON public."HET_DIGITAL_FILE" USING btree ("OWNER_ID");


--
-- Name: IX_HET_DIGITAL_FILE_PROJECT_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_DIGITAL_FILE_PROJECT_ID" ON public."HET_DIGITAL_FILE" USING btree ("PROJECT_ID");


--
-- Name: IX_HET_DIGITAL_FILE_RENTAL_REQUEST_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_DIGITAL_FILE_RENTAL_REQUEST_ID" ON public."HET_DIGITAL_FILE" USING btree ("RENTAL_REQUEST_ID");


--
-- Name: IX_HET_DIGITAL_FILE_MIME_TYPE_ID_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_DIGITAL_FILE_MIME_TYPE_ID" ON public."HET_DIGITAL_FILE" USING btree ("MIME_TYPE_ID");


--
-- Name: IX_HET_CONDITION_TYPE_DISTRICT_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_CONDITION_TYPE_DISTRICT_ID" ON public."HET_CONDITION_TYPE" USING btree ("DISTRICT_ID");


--
-- Name: IX_HET_CONTACT_OWNER_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_CONTACT_OWNER_ID" ON public."HET_CONTACT" USING btree ("OWNER_ID");


--
-- Name: IX_HET_CONTACT_PROJECT_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_CONTACT_PROJECT_ID" ON public."HET_CONTACT" USING btree ("PROJECT_ID");


--
-- Name: IX_HET_DISTRICT_STATUS_DISTRICT_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_DISTRICT_STATUS_DISTRICT_ID" ON public."HET_DISTRICT_STATUS" USING btree ("DISTRICT_ID");


--
-- Name: IX_HET_DISTRICT_EQUIPMENT_TYPE_DISTRICT_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_DISTRICT_EQUIPMENT_TYPE_DISTRICT_ID" ON public."HET_DISTRICT_EQUIPMENT_TYPE" USING btree ("DISTRICT_ID");


--
-- Name: IX_HET_DISTRICT_EQUIPMENT_TYPE_EQUIPMENT_TYPE_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_DISTRICT_EQUIPMENT_TYPE_EQUIPMENT_TYPE_ID" ON public."HET_DISTRICT_EQUIPMENT_TYPE" USING btree ("EQUIPMENT_TYPE_ID");


--
-- Name: IX_HET_DISTRICT_REGION_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_DISTRICT_REGION_ID" ON public."HET_DISTRICT" USING btree ("REGION_ID");


--
-- Name: IX_HET_EQUIPMENT_ATTACHMENT_EQUIPMENT_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_EQUIPMENT_ATTACHMENT_EQUIPMENT_ID" ON public."HET_EQUIPMENT_ATTACHMENT" USING btree ("EQUIPMENT_ID");


--
-- Name: IX_HET_EQUIPMENT_DISTRICT_EQUIPMENT_TYPE_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_EQUIPMENT_DISTRICT_EQUIPMENT_TYPE_ID" ON public."HET_EQUIPMENT" USING btree ("DISTRICT_EQUIPMENT_TYPE_ID");


--
-- Name: IX_HET_EQUIPMENT_LOCAL_AREA_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_EQUIPMENT_LOCAL_AREA_ID" ON public."HET_EQUIPMENT" USING btree ("LOCAL_AREA_ID");


--
-- Name: IX_HET_EQUIPMENT_OWNER_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_EQUIPMENT_OWNER_ID" ON public."HET_EQUIPMENT" USING btree ("OWNER_ID");


--
-- Name: IX_HET_EQUIPMENT_STATUS_TYPE_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_EQUIPMENT_STATUS_TYPE_ID" ON public."HET_EQUIPMENT" USING btree ("EQUIPMENT_STATUS_TYPE_ID");


--
-- Name: IX_HET_HISTORY_EQUIPMENT_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_HISTORY_EQUIPMENT_ID" ON public."HET_HISTORY" USING btree ("EQUIPMENT_ID");


--
-- Name: IX_HET_HISTORY_OWNER_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_HISTORY_OWNER_ID" ON public."HET_HISTORY" USING btree ("OWNER_ID");


--
-- Name: IX_HET_HISTORY_PROJECT_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_HISTORY_PROJECT_ID" ON public."HET_HISTORY" USING btree ("PROJECT_ID");


--
-- Name: IX_HET_HISTORY_RENTAL_REQUEST_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_HISTORY_RENTAL_REQUEST_ID" ON public."HET_HISTORY" USING btree ("RENTAL_REQUEST_ID");


--
-- Name: IX_HET_LOCAL_AREA_ROTATION_LIST_ASK_NEXT_BLOCK1_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_LOCAL_AREA_ROTATION_LIST_ASK_NEXT_BLOCK1_ID" ON public."HET_LOCAL_AREA_ROTATION_LIST" USING btree ("ASK_NEXT_BLOCK1_ID");


--
-- Name: IX_HET_LOCAL_AREA_ROTATION_LIST_ASK_NEXT_BLOCK2_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_LOCAL_AREA_ROTATION_LIST_ASK_NEXT_BLOCK2_ID" ON public."HET_LOCAL_AREA_ROTATION_LIST" USING btree ("ASK_NEXT_BLOCK2_ID");


--
-- Name: IX_HET_LOCAL_AREA_ROTATION_LIST_ASK_NEXT_BLOCK_OPEN_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_LOCAL_AREA_ROTATION_LIST_ASK_NEXT_BLOCK_OPEN_ID" ON public."HET_LOCAL_AREA_ROTATION_LIST" USING btree ("ASK_NEXT_BLOCK_OPEN_ID");


--
-- Name: IX_HET_LOCAL_AREA_ROTATION_LIST_DISTRICT_EQUIPMENT_TYPE_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_LOCAL_AREA_ROTATION_LIST_DISTRICT_EQUIPMENT_TYPE_ID" ON public."HET_LOCAL_AREA_ROTATION_LIST" USING btree ("DISTRICT_EQUIPMENT_TYPE_ID");


--
-- Name: IX_HET_LOCAL_AREA_ROTATION_LIST_LOCAL_AREA_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_LOCAL_AREA_ROTATION_LIST_LOCAL_AREA_ID" ON public."HET_LOCAL_AREA_ROTATION_LIST" USING btree ("LOCAL_AREA_ID");


--
-- Name: IX_HET_LOCAL_AREA_SERVICE_AREA_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_LOCAL_AREA_SERVICE_AREA_ID" ON public."HET_LOCAL_AREA" USING btree ("SERVICE_AREA_ID");


--
-- Name: IX_HET_NOTE_EQUIPMENT_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_NOTE_EQUIPMENT_ID" ON public."HET_NOTE" USING btree ("EQUIPMENT_ID");


--
-- Name: IX_HET_NOTE_OWNER_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_NOTE_OWNER_ID" ON public."HET_NOTE" USING btree ("OWNER_ID");


--
-- Name: IX_HET_NOTE_PROJECT_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_NOTE_PROJECT_ID" ON public."HET_NOTE" USING btree ("PROJECT_ID");


--
-- Name: IX_HET_NOTE_RENTAL_REQUEST_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_NOTE_RENTAL_REQUEST_ID" ON public."HET_NOTE" USING btree ("RENTAL_REQUEST_ID");


--
-- Name: IX_HET_BUSINESS_BUSINESS_GUID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_BUSINESS_BUSINESS_GUID" ON public."HET_BUSINESS" USING btree ("BCEID_BUSINESS_GUID");


--
-- Name: IX_HET_BUSINESS_USER_GUID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_BUSINESS_USER_GUID" ON public."HET_BUSINESS_USER" USING btree ("BCEID_GUID");


--
-- Name: IX_HET_BUSINESS_USER_BUSINESS_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_BUSINESS_USER_BUSINESS_ID" ON public."HET_BUSINESS_USER" USING btree ("BUSINESS_ID");


--
-- Name: IX_HET_BUSINESS_USER_ROLE_USER_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_BUSINESS_USER_ROLE_USER_ID" ON public."HET_BUSINESS_USER_ROLE" USING btree ("BUSINESS_USER_ID");


--
-- Name: IX_HET_BUSINESS_USER_ROLE_ROLE_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_BUSINESS_USER_ROLE_ROLE_ID" ON public."HET_BUSINESS_USER_ROLE" USING btree ("ROLE_ID");


--
-- Name: IX_HET_OWNER_LOCAL_AREA_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_OWNER_LOCAL_AREA_ID" ON public."HET_OWNER" USING btree ("LOCAL_AREA_ID");



--
-- Name: IX_HET_OWNER_BUSINESS_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_OWNER_BUSINESS_ID" ON public."HET_OWNER" USING btree ("BUSINESS_ID");


--
-- Name: IX_HET_OWNER_PRIMARY_CONTACT_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_OWNER_PRIMARY_CONTACT_ID" ON public."HET_OWNER" USING btree ("PRIMARY_CONTACT_ID");


--
-- Name: IX_HET_OWNER_STATUS_TYPE_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_OWNER_STATUS_TYPE_ID" ON public."HET_OWNER" USING btree ("OWNER_STATUS_TYPE_ID");


--
-- Name: IX_HET_PROJECT_DISTRICT_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_PROJECT_DISTRICT_ID" ON public."HET_PROJECT" USING btree ("DISTRICT_ID");


--
-- Name: IX_HET_PROJECT_PRIMARY_CONTACT_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_PROJECT_PRIMARY_CONTACT_ID" ON public."HET_PROJECT" USING btree ("PRIMARY_CONTACT_ID");


--
-- Name: IX_HET_PROJECT_STATUS_TYPE_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_PROJECT_STATUS_TYPE_ID" ON public."HET_PROJECT" USING btree ("PROJECT_STATUS_TYPE_ID");


--
-- Name: IX_HET_RENTAL_AGREEMENT_CONDITION_RENTAL_AGREEMENT_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_RENTAL_AGREEMENT_CONDITION_RENTAL_AGREEMENT_ID" ON public."HET_RENTAL_AGREEMENT_CONDITION" USING btree ("RENTAL_AGREEMENT_ID");


--
-- Name: IX_HET_RENTAL_AGREEMENT_EQUIPMENT_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_RENTAL_AGREEMENT_EQUIPMENT_ID" ON public."HET_RENTAL_AGREEMENT" USING btree ("EQUIPMENT_ID");


--
-- Name: IX_HET_RENTAL_AGREEMENT_PROJECT_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_RENTAL_AGREEMENT_PROJECT_ID" ON public."HET_RENTAL_AGREEMENT" USING btree ("PROJECT_ID");

--
-- Name: IX_HET_RENTAL_AGREEMENT_DISTRICT_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_RENTAL_AGREEMENT_DISTRICT_ID" ON public."HET_RENTAL_AGREEMENT" USING btree ("DISTRICT_ID");


--
-- Name: IX_HET_RENTAL_AGREEMENT_HET_RENTAL_AGREEMENT_STATUS_TYPE_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_RENTAL_AGREEMENT_HET_RENTAL_AGREEMENT_STATUS_TYPE_ID" ON public."HET_RENTAL_AGREEMENT" USING btree ("RENTAL_AGREEMENT_STATUS_TYPE_ID");


--
-- Name: IX_HET_RENTAL_AGREEMENT_HET_RATE_PERIOD_TYPE_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_RENTAL_AGREEMENT_HET_RATE_PERIOD_TYPE_ID" ON public."HET_RENTAL_AGREEMENT" USING btree ("RATE_PERIOD_TYPE_ID");


--
-- Name: IX_HET_RENTAL_AGREEMENT_HET_RENTAL_REQUEST_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_RENTAL_AGREEMENT_HET_RENTAL_REQUEST_ID" ON public."HET_RENTAL_AGREEMENT" USING btree ("RENTAL_REQUEST_ID");


--
-- Name: IX_HET_RENTAL_AGREEMENT_HET_RENTAL_REQUEST_ROTATION_LIST_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_RENTAL_AGREEMENT_HET_RENTAL_REQUEST_ROTATION_LIST_ID" ON public."HET_RENTAL_AGREEMENT" USING btree ("RENTAL_REQUEST_ROTATION_LIST_ID");


--
-- Name: IX_HET_RENTAL_AGREEMENT_RATE_RENTAL_AGREEMENT_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_RENTAL_AGREEMENT_RATE_RENTAL_AGREEMENT_ID" ON public."HET_RENTAL_AGREEMENT_RATE" USING btree ("RENTAL_AGREEMENT_ID");


--
-- Name: IX_HET_RENTAL_REQUEST_ATTACHMENT_RENTAL_REQUEST_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_RENTAL_REQUEST_ATTACHMENT_RENTAL_REQUEST_ID" ON public."HET_RENTAL_REQUEST_ATTACHMENT" USING btree ("RENTAL_REQUEST_ID");


--
-- Name: IX_HET_RENTAL_REQUEST_DISTRICT_EQUIPMENT_TYPE_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_RENTAL_REQUEST_DISTRICT_EQUIPMENT_TYPE_ID" ON public."HET_RENTAL_REQUEST" USING btree ("DISTRICT_EQUIPMENT_TYPE_ID");


--
-- Name: IX_HET_RENTAL_REQUEST_FIRST_ON_ROTATION_LIST_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_RENTAL_REQUEST_FIRST_ON_ROTATION_LIST_ID" ON public."HET_RENTAL_REQUEST" USING btree ("FIRST_ON_ROTATION_LIST_ID");


--
-- Name: IX_HET_RENTAL_REQUEST_LOCAL_AREA_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_RENTAL_REQUEST_LOCAL_AREA_ID" ON public."HET_RENTAL_REQUEST" USING btree ("LOCAL_AREA_ID");


--
-- Name: IX_HET_RENTAL_REQUEST_PROJECT_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_RENTAL_REQUEST_PROJECT_ID" ON public."HET_RENTAL_REQUEST" USING btree ("PROJECT_ID");


--
-- Name: IX_HET_RENTAL_REQUEST_STATUS_TYPE_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_RENTAL_REQUEST_STATUS_TYPE_ID" ON public."HET_RENTAL_REQUEST" USING btree ("RENTAL_REQUEST_STATUS_TYPE_ID");


--
-- Name: IX_HET_RENTAL_REQUEST_ROTATION_LIST_EQUIPMENT_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_RENTAL_REQUEST_ROTATION_LIST_EQUIPMENT_ID" ON public."HET_RENTAL_REQUEST_ROTATION_LIST" USING btree ("EQUIPMENT_ID");


--
-- Name: IX_HET_RENTAL_REQUEST_ROTATION_LIST_RENTAL_AGREEMENT_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_RENTAL_REQUEST_ROTATION_LIST_RENTAL_AGREEMENT_ID" ON public."HET_RENTAL_REQUEST_ROTATION_LIST" USING btree ("RENTAL_AGREEMENT_ID");


--
-- Name: IX_HET_RENTAL_REQUEST_ROTATION_LIST_RENTAL_REQUEST_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_RENTAL_REQUEST_ROTATION_LIST_RENTAL_REQUEST_ID" ON public."HET_RENTAL_REQUEST_ROTATION_LIST" USING btree ("RENTAL_REQUEST_ID");


--
-- Name: IX_HET_ROLE_PERMISSION_PERMISSION_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_ROLE_PERMISSION_PERMISSION_ID" ON public."HET_ROLE_PERMISSION" USING btree ("PERMISSION_ID");


--
-- Name: IX_HET_ROLE_PERMISSION_ROLE_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_ROLE_PERMISSION_ROLE_ID" ON public."HET_ROLE_PERMISSION" USING btree ("ROLE_ID");


--
-- Name: IX_HET_SENIORITY_AUDIT_EQUIPMENT_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_SENIORITY_AUDIT_EQUIPMENT_ID" ON public."HET_SENIORITY_AUDIT" USING btree ("EQUIPMENT_ID");


--
-- Name: IX_HET_SENIORITY_AUDIT_LOCAL_AREA_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_SENIORITY_AUDIT_LOCAL_AREA_ID" ON public."HET_SENIORITY_AUDIT" USING btree ("LOCAL_AREA_ID");


--
-- Name: IX_HET_SENIORITY_AUDIT_OWNER_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_SENIORITY_AUDIT_OWNER_ID" ON public."HET_SENIORITY_AUDIT" USING btree ("OWNER_ID");


--
-- Name: IX_HET_SERVICE_AREA_DISTRICT_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_SERVICE_AREA_DISTRICT_ID" ON public."HET_SERVICE_AREA" USING btree ("DISTRICT_ID");


--
-- Name: IX_HET_TIME_RECORD_RENTAL_AGREEMENT_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_TIME_RECORD_RENTAL_AGREEMENT_ID" ON public."HET_TIME_RECORD" USING btree ("RENTAL_AGREEMENT_ID");


--
-- Name: IX_HET_TIME_RECORD_RENTAL_AGREEMENT_RATE_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_TIME_RECORD_RENTAL_AGREEMENT_RATE_ID" ON public."HET_TIME_RECORD" USING btree ("RENTAL_AGREEMENT_RATE_ID");


--
-- Name: IX_HET_TIME_RECORD_TIME_PERIOD_TYPE_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_TIME_RECORD_TIME_PERIOD_TYPE_ID" ON public."HET_TIME_RECORD" USING btree ("TIME_PERIOD_TYPE_ID");


--
-- Name: IX_HET_USER_DISTRICT_DISTRICT_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_USER_DISTRICT_DISTRICT_ID" ON public."HET_USER_DISTRICT" USING btree ("DISTRICT_ID");


--
-- Name: IX_HET_USER_DISTRICT_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_USER_DISTRICT_ID" ON public."HET_USER" USING btree ("DISTRICT_ID");


--
-- Name: IX_HET_USER_DISTRICT_USER_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_USER_DISTRICT_USER_ID" ON public."HET_USER_DISTRICT" USING btree ("USER_ID");


--
-- Name: IX_HET_USER_FAVOURITE_USER_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_USER_FAVOURITE_USER_ID" ON public."HET_USER_FAVOURITE" USING btree ("USER_ID");


--
-- Name: IX_HET_USER_FAVOURITE_DISTRICT_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_USER_FAVOURITE_DISTRICT_ID" ON public."HET_USER_FAVOURITE" USING btree ("DISTRICT_ID");


--
-- Name: IX_HET_USER_ROLE_ROLE_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_USER_ROLE_ROLE_ID" ON public."HET_USER_ROLE" USING btree ("ROLE_ID");


--
-- Name: IX_HET_USER_ROLE_USER_ID; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX "IX_HET_USER_ROLE_USER_ID" ON public."HET_USER_ROLE" USING btree ("USER_ID");


--
-- Name: ix_hangfire_counter_expireat; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX ix_hangfire_counter_expireat ON public.counter USING btree (expireat);


--
-- Name: ix_hangfire_counter_key; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX ix_hangfire_counter_key ON public.counter USING btree (key);


--
-- Name: ix_hangfire_job_statename; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX ix_hangfire_job_statename ON public.job USING btree (statename);


--
-- Name: ix_hangfire_jobparameter_jobidandname; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX ix_hangfire_jobparameter_jobidandname ON public.jobparameter USING btree (jobid, name);


--
-- Name: ix_hangfire_jobqueue_jobidandqueue; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX ix_hangfire_jobqueue_jobidandqueue ON public.jobqueue USING btree (jobid, queue);


--
-- Name: ix_hangfire_jobqueue_queueandfetchedat; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX ix_hangfire_jobqueue_queueandfetchedat ON public.jobqueue USING btree (queue, fetchedat);


--
-- Name: ix_hangfire_state_jobid; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX ix_hangfire_state_jobid ON public.state USING btree (jobid);


--
-- Name: HET_DIGITAL_FILE FK_HET_DIGITAL_FILE_EQUIPMENT_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_DIGITAL_FILE"
    ADD CONSTRAINT "FK_HET_DIGITAL_FILE_EQUIPMENT_ID" FOREIGN KEY ("EQUIPMENT_ID") REFERENCES public."HET_EQUIPMENT"("EQUIPMENT_ID");


--
-- Name: HET_DIGITAL_FILE FK_HET_DIGITAL_FILE_OWNER_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_DIGITAL_FILE"
    ADD CONSTRAINT "FK_HET_DIGITAL_FILE_OWNER_ID" FOREIGN KEY ("OWNER_ID") REFERENCES public."HET_OWNER"("OWNER_ID");


--
-- Name: HET_DIGITAL_FILE FK_HET_DIGITAL_FILE_PROJECT_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_DIGITAL_FILE"
    ADD CONSTRAINT "FK_HET_DIGITAL_FILE_PROJECT_ID" FOREIGN KEY ("PROJECT_ID") REFERENCES public."HET_PROJECT"("PROJECT_ID");


--
-- Name: HET_DIGITAL_FILE FK_HET_DIGITAL_FILE_RENTAL_REQUEST_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_DIGITAL_FILE"
    ADD CONSTRAINT "FK_HET_DIGITAL_FILE_RENTAL_REQUEST_ID" FOREIGN KEY ("RENTAL_REQUEST_ID") REFERENCES public."HET_RENTAL_REQUEST"("RENTAL_REQUEST_ID");


--
-- Name: HET_DIGITAL_FILE FK_HET_DIGITAL_FILE_MIME_TYPE_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_DIGITAL_FILE"
    ADD CONSTRAINT "FK_HET_DIGITAL_FILE_MIME_TYPE_ID" FOREIGN KEY ("MIME_TYPE_ID") REFERENCES public."HET_MIME_TYPE"("MIME_TYPE_ID");

	
--
-- Name: HET_CONDITION_TYPE FK_HET_CONDITION_TYPE_DISTRICT_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_CONDITION_TYPE"
    ADD CONSTRAINT "FK_HET_CONDITION_TYPE_DISTRICT_ID" FOREIGN KEY ("DISTRICT_ID") REFERENCES public."HET_DISTRICT"("DISTRICT_ID") ON DELETE RESTRICT;


--
-- Name: HET_CONTACT FK_HET_CONTACT_OWNER_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_CONTACT"
    ADD CONSTRAINT "FK_HET_CONTACT_OWNER_ID" FOREIGN KEY ("OWNER_ID") REFERENCES public."HET_OWNER"("OWNER_ID");


--
-- Name: HET_CONTACT FK_HET_CONTACT_PROJECT_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_CONTACT"
    ADD CONSTRAINT "FK_HET_CONTACT_PROJECT_ID" FOREIGN KEY ("PROJECT_ID") REFERENCES public."HET_PROJECT"("PROJECT_ID");


--
-- Name: HET_DISTRICT_STATUS FK_HET_DISTRICT_STATUS_DISTRICT_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_DISTRICT_STATUS"
    ADD CONSTRAINT "FK_HET_DISTRICT_STATUS_DISTRICT_ID" FOREIGN KEY ("DISTRICT_ID") REFERENCES public."HET_DISTRICT"("DISTRICT_ID");


--
-- Name: HET_DISTRICT_EQUIPMENT_TYPE FK_HET_DISTRICT_EQUIPMENT_TYPE_DISTRICT_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_DISTRICT_EQUIPMENT_TYPE"
    ADD CONSTRAINT "FK_HET_DISTRICT_EQUIPMENT_TYPE_DISTRICT_ID" FOREIGN KEY ("DISTRICT_ID") REFERENCES public."HET_DISTRICT"("DISTRICT_ID");


--
-- Name: HET_DISTRICT_EQUIPMENT_TYPE FK_HET_DISTRICT_EQUIPMENT_TYPE_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_DISTRICT_EQUIPMENT_TYPE"
    ADD CONSTRAINT "FK_HET_DISTRICT_EQUIPMENT_TYPE_ID" FOREIGN KEY ("EQUIPMENT_TYPE_ID") REFERENCES public."HET_EQUIPMENT_TYPE"("EQUIPMENT_TYPE_ID");


--
-- Name: HET_DISTRICT FK_HET_DISTRICT_REGION_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_DISTRICT"
    ADD CONSTRAINT "FK_HET_DISTRICT_REGION_ID" FOREIGN KEY ("REGION_ID") REFERENCES public."HET_REGION"("REGION_ID");


--
-- Name: HET_EQUIPMENT_ATTACHMENT FK_HET_EQUIPMENT_ATTACHMENT_EQUIPMENT_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_EQUIPMENT_ATTACHMENT"
    ADD CONSTRAINT "FK_HET_EQUIPMENT_ATTACHMENT_EQUIPMENT_ID" FOREIGN KEY ("EQUIPMENT_ID") REFERENCES public."HET_EQUIPMENT"("EQUIPMENT_ID");


--
-- Name: HET_EQUIPMENT FK_HET_EQUIPMENT_DISTRICT_EQUIPMENT_TYPE_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_EQUIPMENT"
    ADD CONSTRAINT "FK_HET_EQUIPMENT_DISTRICT_EQUIPMENT_TYPE_ID" FOREIGN KEY ("DISTRICT_EQUIPMENT_TYPE_ID") REFERENCES public."HET_DISTRICT_EQUIPMENT_TYPE"("DISTRICT_EQUIPMENT_TYPE_ID");


--
-- Name: HET_EQUIPMENT FK_HET_EQUIPMENT_LOCAL_AREA_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_EQUIPMENT"
    ADD CONSTRAINT "FK_HET_EQUIPMENT_LOCAL_AREA_ID" FOREIGN KEY ("LOCAL_AREA_ID") REFERENCES public."HET_LOCAL_AREA"("LOCAL_AREA_ID");


--
-- Name: HET_EQUIPMENT FK_HET_EQUIPMENT_OWNER_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_EQUIPMENT"
    ADD CONSTRAINT "FK_HET_EQUIPMENT_OWNER_ID" FOREIGN KEY ("OWNER_ID") REFERENCES public."HET_OWNER"("OWNER_ID");

	
--
-- Name: HET_EQUIPMENT FK_HET_EQUIPMENT_STATUS_TYPE_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_EQUIPMENT"
    ADD CONSTRAINT "FK_HET_EQUIPMENT_STATUS_TYPE_ID" FOREIGN KEY ("EQUIPMENT_STATUS_TYPE_ID") REFERENCES public."HET_EQUIPMENT_STATUS_TYPE"("EQUIPMENT_STATUS_TYPE_ID");


--
-- Name: HET_HISTORY FK_HET_HISTORY_EQUIPMENT_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_HISTORY"
    ADD CONSTRAINT "FK_HET_HISTORY_EQUIPMENT_ID" FOREIGN KEY ("EQUIPMENT_ID") REFERENCES public."HET_EQUIPMENT"("EQUIPMENT_ID");


--
-- Name: HET_HISTORY FK_HET_HISTORY_OWNER_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_HISTORY"
    ADD CONSTRAINT "FK_HET_HISTORY_OWNER_ID" FOREIGN KEY ("OWNER_ID") REFERENCES public."HET_OWNER"("OWNER_ID");


--
-- Name: HET_HISTORY FK_HET_HISTORY_PROJECT_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_HISTORY"
    ADD CONSTRAINT "FK_HET_HISTORY_PROJECT_ID" FOREIGN KEY ("PROJECT_ID") REFERENCES public."HET_PROJECT"("PROJECT_ID");


--
-- Name: HET_HISTORY FK_HET_HISTORY_RENTAL_REQUEST_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_HISTORY"
    ADD CONSTRAINT "FK_HET_HISTORY_RENTAL_REQUEST_ID" FOREIGN KEY ("RENTAL_REQUEST_ID") REFERENCES public."HET_RENTAL_REQUEST"("RENTAL_REQUEST_ID");


--
-- Name: HET_LOCAL_AREA FK_HET_LOCAL_AREA_SERVICE_AREA_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_LOCAL_AREA"
    ADD CONSTRAINT "FK_HET_LOCAL_AREA_SERVICE_AREA_ID" FOREIGN KEY ("SERVICE_AREA_ID") REFERENCES public."HET_SERVICE_AREA"("SERVICE_AREA_ID");


--
-- Name: HET_LOCAL_AREA_ROTATION_LIST FK_HET_LOCAL_AREA_ROTATION_LIST_DISTRICT_EQUIPMENT_TYPE_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_LOCAL_AREA_ROTATION_LIST"
    ADD CONSTRAINT "FK_HET_LOCAL_AREA_ROTATION_LIST_DISTRICT_EQUIPMENT_TYPE_ID" FOREIGN KEY ("DISTRICT_EQUIPMENT_TYPE_ID") REFERENCES public."HET_DISTRICT_EQUIPMENT_TYPE"("DISTRICT_EQUIPMENT_TYPE_ID");


--
-- Name: HET_LOCAL_AREA_ROTATION_LIST FK_HET_LOCAL_AREA_ROTATION_LIST_ASK_NEXT_BLOCK1_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_LOCAL_AREA_ROTATION_LIST"
    ADD CONSTRAINT "FK_HET_LOCAL_AREA_ROTATION_LIST_ASK_NEXT_BLOCK1_ID" FOREIGN KEY ("ASK_NEXT_BLOCK1_ID") REFERENCES public."HET_EQUIPMENT"("EQUIPMENT_ID");


--
-- Name: HET_LOCAL_AREA_ROTATION_LIST FK_HET_LOCAL_AREA_ROTATION_LIST_ASK_NEXT_BLOCK2_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_LOCAL_AREA_ROTATION_LIST"
    ADD CONSTRAINT "FK_HET_LOCAL_AREA_ROTATION_LIST_ASK_NEXT_BLOCK2_ID" FOREIGN KEY ("ASK_NEXT_BLOCK2_ID") REFERENCES public."HET_EQUIPMENT"("EQUIPMENT_ID");


--
-- Name: HET_LOCAL_AREA_ROTATION_LIST FK_HET_LOCAL_AREA_ROTATION_LIST_ASK_NEXT_BLOCK_OPEN_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_LOCAL_AREA_ROTATION_LIST"
    ADD CONSTRAINT "FK_HET_LOCAL_AREA_ROTATION_LIST_ASK_NEXT_BLOCK_OPEN_ID" FOREIGN KEY ("ASK_NEXT_BLOCK_OPEN_ID") REFERENCES public."HET_EQUIPMENT"("EQUIPMENT_ID");


--
-- Name: HET_LOCAL_AREA_ROTATION_LIST FK_HET_LOCAL_AREA_ROTATION_LIST_LOCAL_AREA_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_LOCAL_AREA_ROTATION_LIST"
    ADD CONSTRAINT "FK_HET_LOCAL_AREA_ROTATION_LIST_LOCAL_AREA_ID" FOREIGN KEY ("LOCAL_AREA_ID") REFERENCES public."HET_LOCAL_AREA"("LOCAL_AREA_ID");


--
-- Name: HET_NOTE FK_HET_NOTE_EQUIPMENT_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_NOTE"
    ADD CONSTRAINT "FK_HET_NOTE_EQUIPMENT_ID" FOREIGN KEY ("EQUIPMENT_ID") REFERENCES public."HET_EQUIPMENT"("EQUIPMENT_ID");


--
-- Name: HET_NOTE FK_HET_NOTE_OWNER_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_NOTE"
    ADD CONSTRAINT "FK_HET_NOTE_OWNER_ID" FOREIGN KEY ("OWNER_ID") REFERENCES public."HET_OWNER"("OWNER_ID");


--
-- Name: HET_NOTE FK_HET_NOTE_PROJECT_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_NOTE"
    ADD CONSTRAINT "FK_HET_NOTE_PROJECT_ID" FOREIGN KEY ("PROJECT_ID") REFERENCES public."HET_PROJECT"("PROJECT_ID");


--
-- Name: HET_NOTE FK_HET_NOTE_RENTAL_REQUEST_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_NOTE"
    ADD CONSTRAINT "FK_HET_NOTE_RENTAL_REQUEST_ID" FOREIGN KEY ("RENTAL_REQUEST_ID") REFERENCES public."HET_RENTAL_REQUEST"("RENTAL_REQUEST_ID");

	
--
-- Name: HET_OWNER FK_HET_BUSINESS_USER_BUSINESS_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_BUSINESS_USER"
    ADD CONSTRAINT "FK_HET_BUSINESS_USER_BUSINESS_ID" FOREIGN KEY ("BUSINESS_ID") REFERENCES public."HET_BUSINESS"("BUSINESS_ID");

	
--
-- Name: HET_OWNER FK_HET_BUSINESS_USER_ROLE_USER_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_BUSINESS_USER_ROLE"
    ADD CONSTRAINT "FK_HET_BUSINESS_USER_ROLE_USER_ID" FOREIGN KEY ("BUSINESS_USER_ID") REFERENCES public."HET_BUSINESS_USER"("BUSINESS_USER_ID");
	
--
-- Name: HET_OWNER FK_HET_BUSINESS_USER_ROLE_ROLE_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_BUSINESS_USER_ROLE"
    ADD CONSTRAINT "FK_HET_BUSINESS_USER_ROLE_ROLE_ID" FOREIGN KEY ("ROLE_ID") REFERENCES public."HET_ROLE"("ROLE_ID");

	
--
-- Name: HET_OWNER FK_HET_OWNER_PRIMARY_CONTACT_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_OWNER"
    ADD CONSTRAINT "FK_HET_OWNER_PRIMARY_CONTACT_ID" FOREIGN KEY ("PRIMARY_CONTACT_ID") REFERENCES public."HET_CONTACT"("CONTACT_ID");

	
--
-- Name: HET_OWNER FK_HET_OWNER_BUSINESS_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_OWNER"
    ADD CONSTRAINT "FK_HET_OWNER_BUSINESS_ID" FOREIGN KEY ("BUSINESS_ID") REFERENCES public."HET_BUSINESS"("BUSINESS_ID");
	

--
-- Name: HET_OWNER FK_HET_OWNER_LOCAL_AREA_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_OWNER"
    ADD CONSTRAINT "FK_HET_OWNER_LOCAL_AREA_ID" FOREIGN KEY ("LOCAL_AREA_ID") REFERENCES public."HET_LOCAL_AREA"("LOCAL_AREA_ID");


--
-- Name: HET_OWNER FK_HET_OWNER_STATUS_TYPE_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_OWNER"
    ADD CONSTRAINT "FK_HET_OWNER_STATUS_TYPE_ID" FOREIGN KEY ("OWNER_STATUS_TYPE_ID") REFERENCES public."HET_OWNER_STATUS_TYPE"("OWNER_STATUS_TYPE_ID");

	
	
--
-- Name: HET_PROJECT FK_HET_PROJECT_PRIMARY_CONTACT_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_PROJECT"
    ADD CONSTRAINT "FK_HET_PROJECT_PRIMARY_CONTACT_ID" FOREIGN KEY ("PRIMARY_CONTACT_ID") REFERENCES public."HET_CONTACT"("CONTACT_ID");


--
-- Name: HET_PROJECT FK_HET_PROJECT_DISTRICT_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_PROJECT"
    ADD CONSTRAINT "FK_HET_PROJECT_DISTRICT_ID" FOREIGN KEY ("DISTRICT_ID") REFERENCES public."HET_DISTRICT"("DISTRICT_ID");


--
-- Name: HET_PROJECT FK_HET_PROJECT_HET_PROJECT_STATUS_TYPE_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_PROJECT"
    ADD CONSTRAINT "FK_HET_PROJECT_HET_PROJECT_STATUS_TYPE_ID" FOREIGN KEY ("PROJECT_STATUS_TYPE_ID") REFERENCES public."HET_PROJECT_STATUS_TYPE"("PROJECT_STATUS_TYPE_ID");

	
--
-- Name: HET_RENTAL_AGREEMENT_CONDITION FK_HET_RENTAL_AGREEMENT_CONDITION_RENTAL_AGREEMENT_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_RENTAL_AGREEMENT_CONDITION"
    ADD CONSTRAINT "FK_HET_RENTAL_AGREEMENT_CONDITION_RENTAL_AGREEMENT_ID" FOREIGN KEY ("RENTAL_AGREEMENT_ID") REFERENCES public."HET_RENTAL_AGREEMENT"("RENTAL_AGREEMENT_ID");


--
-- Name: HET_RENTAL_AGREEMENT FK_HET_RENTAL_AGREEMENT_EQUIPMENT_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_RENTAL_AGREEMENT"
    ADD CONSTRAINT "FK_HET_RENTAL_AGREEMENT_EQUIPMENT_ID" FOREIGN KEY ("EQUIPMENT_ID") REFERENCES public."HET_EQUIPMENT"("EQUIPMENT_ID");


--
-- Name: HET_RENTAL_AGREEMENT FK_HET_RENTAL_AGREEMENT_STATUS_TYPE_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_RENTAL_AGREEMENT"
    ADD CONSTRAINT "FK_HET_RENTAL_AGREEMENT_STATUS_TYPE_ID" FOREIGN KEY ("RENTAL_AGREEMENT_STATUS_TYPE_ID") REFERENCES public."HET_RENTAL_AGREEMENT_STATUS_TYPE"("RENTAL_AGREEMENT_STATUS_TYPE_ID");
	

--
-- Name: HET_RENTAL_AGREEMENT FK_HET_RENTAL_AGREEMENT_RATE_PERIOD_TYPE_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_RENTAL_AGREEMENT"
    ADD CONSTRAINT "FK_HET_RENTAL_AGREEMENT_RATE_PERIOD_TYPE_ID" FOREIGN KEY ("RATE_PERIOD_TYPE_ID") REFERENCES public."HET_RATE_PERIOD_TYPE"("RATE_PERIOD_TYPE_ID");
	

--
-- Name: HET_RENTAL_AGREEMENT FK_HET_RENTAL_AGREEMENT_PROJECT_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_RENTAL_AGREEMENT"
    ADD CONSTRAINT "FK_HET_RENTAL_AGREEMENT_PROJECT_ID" FOREIGN KEY ("PROJECT_ID") REFERENCES public."HET_PROJECT"("PROJECT_ID");

--
-- Name: HET_RENTAL_AGREEMENT FK_HET_RENTAL_AGREEMENT_DISTRICT_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_RENTAL_AGREEMENT"
    ADD CONSTRAINT "FK_HET_RENTAL_AGREEMENT_DISTRICT_ID" FOREIGN KEY ("DISTRICT_ID") REFERENCES public."HET_DISTRICT"("DISTRICT_ID");

	
--
-- Name: HET_RENTAL_AGREEMENT FK_HET_RENTAL_AGREEMENT_RENTAL_REQUEST_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_RENTAL_AGREEMENT"
    ADD CONSTRAINT "FK_HET_RENTAL_AGREEMENT_RENTAL_REQUEST_ID" FOREIGN KEY ("RENTAL_REQUEST_ID") REFERENCES public."HET_RENTAL_REQUEST"("RENTAL_REQUEST_ID");


--
-- Name: HET_RENTAL_AGREEMENT FK_HET_RENTAL_AGREEMENT_RENTAL_REQUEST_ROTATION_LIST_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_RENTAL_AGREEMENT"
    ADD CONSTRAINT "FK_HET_RENTAL_AGREEMENT_RENTAL_REQUEST_ROTATION_LIST_ID" FOREIGN KEY ("RENTAL_REQUEST_ROTATION_LIST_ID") REFERENCES public."HET_RENTAL_REQUEST_ROTATION_LIST"("RENTAL_REQUEST_ROTATION_LIST_ID");
		
	
	
--
-- Name: HET_RENTAL_AGREEMENT_RATE FK_HET_RENTAL_AGREEMENT_RATE_AGREEMENT_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_RENTAL_AGREEMENT_RATE"
    ADD CONSTRAINT "FK_HET_RENTAL_AGREEMENT_RATE_AGREEMENT_ID" FOREIGN KEY ("RENTAL_AGREEMENT_ID") REFERENCES public."HET_RENTAL_AGREEMENT"("RENTAL_AGREEMENT_ID");


	
--
-- Name: HET_RENTAL_REQUEST_ATTACHMENT FK_HET_RENTAL_REQUEST_ATTACHMENT_RENTAL_REQUEST_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_RENTAL_REQUEST_ATTACHMENT"
    ADD CONSTRAINT "FK_HET_RENTAL_REQUEST_ATTACHMENT_RENTAL_REQUEST_ID" FOREIGN KEY ("RENTAL_REQUEST_ID") REFERENCES public."HET_RENTAL_REQUEST"("RENTAL_REQUEST_ID");


--
-- Name: HET_RENTAL_REQUEST FK_HET_RENTAL_REQUEST_DISTRICT_EQUIPMENT_TYPE_DISTRICT_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_RENTAL_REQUEST"
    ADD CONSTRAINT "FK_HET_RENTAL_REQUEST_DISTRICT_EQUIPMENT_TYPE_DISTRICT_ID" FOREIGN KEY ("DISTRICT_EQUIPMENT_TYPE_ID") REFERENCES public."HET_DISTRICT_EQUIPMENT_TYPE"("DISTRICT_EQUIPMENT_TYPE_ID");


--
-- Name: HET_RENTAL_REQUEST FK_HET_RENTAL_REQUEST_FIRST_ON_ROTATION_LIST_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_RENTAL_REQUEST"
    ADD CONSTRAINT "FK_HET_RENTAL_REQUEST_FIRST_ON_ROTATION_LIST_ID" FOREIGN KEY ("FIRST_ON_ROTATION_LIST_ID") REFERENCES public."HET_EQUIPMENT"("EQUIPMENT_ID");


--
-- Name: HET_RENTAL_REQUEST FK_HET_RENTAL_REQUEST_LOCAL_AREA_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_RENTAL_REQUEST"
    ADD CONSTRAINT "FK_HET_RENTAL_REQUEST_LOCAL_AREA_ID" FOREIGN KEY ("LOCAL_AREA_ID") REFERENCES public."HET_LOCAL_AREA"("LOCAL_AREA_ID");


--
-- Name: HET_RENTAL_REQUEST FK_HET_RENTAL_REQUEST_PROJECT_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_RENTAL_REQUEST"
    ADD CONSTRAINT "FK_HET_RENTAL_REQUEST_PROJECT_ID" FOREIGN KEY ("PROJECT_ID") REFERENCES public."HET_PROJECT"("PROJECT_ID");
	

--
-- Name: HET_RENTAL_REQUEST FK_HET_RENTAL_REQUEST_STATUS_TYPE_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_RENTAL_REQUEST"
    ADD CONSTRAINT "FK_HET_RENTAL_REQUEST_STATUS_TYPE_ID" FOREIGN KEY ("RENTAL_REQUEST_STATUS_TYPE_ID") REFERENCES public."HET_RENTAL_REQUEST_STATUS_TYPE"("RENTAL_REQUEST_STATUS_TYPE_ID");


--
-- Name: HET_RENTAL_REQUEST_ROTATION_LIST FK_HET_RENTAL_REQUEST_ROTATION_LIST_EQUIPMENT_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_RENTAL_REQUEST_ROTATION_LIST"
    ADD CONSTRAINT "FK_HET_RENTAL_REQUEST_ROTATION_LIST_EQUIPMENT_ID" FOREIGN KEY ("EQUIPMENT_ID") REFERENCES public."HET_EQUIPMENT"("EQUIPMENT_ID");


--
-- Name: HET_RENTAL_REQUEST_ROTATION_LIST FK_HET_RENTAL_REQUEST_ROTATION_LIST_RENTAL_AGREEMENT_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_RENTAL_REQUEST_ROTATION_LIST"
    ADD CONSTRAINT "FK_HET_RENTAL_REQUEST_ROTATION_LIST_RENTAL_AGREEMENT_ID" FOREIGN KEY ("RENTAL_AGREEMENT_ID") REFERENCES public."HET_RENTAL_AGREEMENT"("RENTAL_AGREEMENT_ID");


--
-- Name: HET_RENTAL_REQUEST_ROTATION_LIST FK_HET_RENTAL_REQUEST_ROTATION_LIST_RENTAL_REQUEST_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_RENTAL_REQUEST_ROTATION_LIST"
    ADD CONSTRAINT "FK_HET_RENTAL_REQUEST_ROTATION_LIST_RENTAL_REQUEST_ID" FOREIGN KEY ("RENTAL_REQUEST_ID") REFERENCES public."HET_RENTAL_REQUEST"("RENTAL_REQUEST_ID");


--
-- Name: HET_ROLE_PERMISSION FK_HET_ROLE_PERMISSION_PERMISSION_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_ROLE_PERMISSION"
    ADD CONSTRAINT "FK_HET_ROLE_PERMISSION_PERMISSION_ID" FOREIGN KEY ("PERMISSION_ID") REFERENCES public."HET_PERMISSION"("PERMISSION_ID");


--
-- Name: HET_ROLE_PERMISSION FK_HET_ROLE_PERMISSION_ROLE_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_ROLE_PERMISSION"
    ADD CONSTRAINT "FK_HET_ROLE_PERMISSION_ROLE_ID" FOREIGN KEY ("ROLE_ID") REFERENCES public."HET_ROLE"("ROLE_ID");


--
-- Name: HET_SENIORITY_AUDIT FK_HET_SENIORITY_AUDIT_EQUIPMENT_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_SENIORITY_AUDIT"
    ADD CONSTRAINT "FK_HET_SENIORITY_AUDIT_EQUIPMENT_ID" FOREIGN KEY ("EQUIPMENT_ID") REFERENCES public."HET_EQUIPMENT"("EQUIPMENT_ID");


--
-- Name: HET_SENIORITY_AUDIT FK_HET_SENIORITY_AUDIT_LOCAL_AREA_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_SENIORITY_AUDIT"
    ADD CONSTRAINT "FK_HET_SENIORITY_AUDIT_LOCAL_AREA_ID" FOREIGN KEY ("LOCAL_AREA_ID") REFERENCES public."HET_LOCAL_AREA"("LOCAL_AREA_ID");


--
-- Name: HET_SENIORITY_AUDIT FK_HET_SENIORITY_AUDIT_OWNER_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_SENIORITY_AUDIT"
    ADD CONSTRAINT "FK_HET_SENIORITY_AUDIT_OWNER_ID" FOREIGN KEY ("OWNER_ID") REFERENCES public."HET_OWNER"("OWNER_ID");


--
-- Name: HET_SERVICE_AREA FK_HET_SERVICE_AREA_DISTRICT_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_SERVICE_AREA"
    ADD CONSTRAINT "FK_HET_SERVICE_AREA_DISTRICT_ID" FOREIGN KEY ("DISTRICT_ID") REFERENCES public."HET_DISTRICT"("DISTRICT_ID");


--
-- Name: HET_TIME_RECORD FK_HET_TIME_RECORD_RENTAL_AGREEMENT_RATE_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_TIME_RECORD"
    ADD CONSTRAINT "FK_HET_TIME_RECORD_RENTAL_AGREEMENT_RATE_ID" FOREIGN KEY ("RENTAL_AGREEMENT_RATE_ID") REFERENCES public."HET_RENTAL_AGREEMENT_RATE"("RENTAL_AGREEMENT_RATE_ID");


--
-- Name: HET_TIME_RECORD FK_HET_TIME_RECORD_RENTAL_AGREEMENT_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_TIME_RECORD"
    ADD CONSTRAINT "FK_HET_TIME_RECORD_RENTAL_AGREEMENT_ID" FOREIGN KEY ("RENTAL_AGREEMENT_ID") REFERENCES public."HET_RENTAL_AGREEMENT"("RENTAL_AGREEMENT_ID");


--
-- Name: HET_TIME_RECORD FK_HET_TIME_RECORD_TIME_PERIOD_TYPE_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_TIME_RECORD"
    ADD CONSTRAINT "FK_HET_TIME_RECORD_TIME_PERIOD_TYPE_ID" FOREIGN KEY ("TIME_PERIOD_TYPE_ID") REFERENCES public."HET_TIME_PERIOD_TYPE"("TIME_PERIOD_TYPE_ID");


	
--
-- Name: HET_USER_DISTRICT FK_HET_USER_DISTRICT_DISTRICT_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_USER_DISTRICT"
    ADD CONSTRAINT "FK_HET_USER_DISTRICT_DISTRICT_ID" FOREIGN KEY ("DISTRICT_ID") REFERENCES public."HET_DISTRICT"("DISTRICT_ID") ON DELETE RESTRICT;


--
-- Name: HET_USER_DISTRICT FK_HET_USER_DISTRICT_USER_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_USER_DISTRICT"
    ADD CONSTRAINT "FK_HET_USER_DISTRICT_USER_ID" FOREIGN KEY ("USER_ID") REFERENCES public."HET_USER"("USER_ID") ON DELETE RESTRICT;


--
-- Name: HET_USER_FAVOURITE FK_HET_USER_FAVOURITE_USER_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_USER_FAVOURITE"
    ADD CONSTRAINT "FK_HET_USER_FAVOURITE_USER_ID" FOREIGN KEY ("USER_ID") REFERENCES public."HET_USER"("USER_ID");


--
-- Name: HET_USER_FAVOURITE FK_HET_USER_FAVOURITE_DISTRICT_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_USER_FAVOURITE"
    ADD CONSTRAINT "FK_HET_USER_FAVOURITE_DISTRICT_ID" FOREIGN KEY ("DISTRICT_ID") REFERENCES public."HET_DISTRICT"("DISTRICT_ID");
	

--
-- Name: HET_USER FK_HET_USER_DISTRICT_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_USER"
    ADD CONSTRAINT "FK_HET_USER_DISTRICT_ID" FOREIGN KEY ("DISTRICT_ID") REFERENCES public."HET_DISTRICT"("DISTRICT_ID");


--
-- Name: HET_USER_ROLE FK_HET_USER_ROLE_ROLE_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_USER_ROLE"
    ADD CONSTRAINT "FK_HET_USER_ROLE_ROLE_ID" FOREIGN KEY ("ROLE_ID") REFERENCES public."HET_ROLE"("ROLE_ID");


--
-- Name: HET_USER_ROLE FK_HET_USER_ROLE_USER_ID; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public."HET_USER_ROLE"
    ADD CONSTRAINT "FK_HET_USER_ROLE_USER_ID" FOREIGN KEY ("USER_ID") REFERENCES public."HET_USER"("USER_ID");


--
-- Name: jobparameter jobparameter_jobid_fkey; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.jobparameter
    ADD CONSTRAINT jobparameter_jobid_fkey FOREIGN KEY (jobid) REFERENCES public.job(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: state state_jobid_fkey; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.state
    ADD CONSTRAINT state_jobid_fkey FOREIGN KEY (jobid) REFERENCES public.job(id) ON UPDATE CASCADE ON DELETE CASCADE;
